#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
// hexy juliaMod01.fsh   by   pb  
//https://www.shadertoy.com/view/McGcW3
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

#define t iTime/3.
#define too_small 1e-4
#define rot(a) mat2(cos(a+vec4(0,11,33,0)))

float[] sc = float[] (1.,1.5,4.,2.,10.,1.2);
float[] mixf = float[] (0.,1.,1.,1.,1.,1.);
float[] jp = float[] (-.83,-1.71,-.83,-.8,.0127,-1.5);

//abs(z^3) + c yields hexagonal symmetry

void mainImage0( out vec4 O, vec2 u )
{
    float tt = mod(iTime,18.);
    int ii = int(mod(tt/3.,6.));
    
    vec2  R =  iResolution.xy, m=iMouse.xy, z,
          U = ( u+u - R )/ R.y * sc[ii] ,
          M = iMouse.z>0.
          ? vec2( 1. - iMouse.x / R.x * 3.2, 0) 
          : vec2( jp[ii], 0);
          
    float i = 0.;
    
    z=U;  //Julia set: input is each pixel coordinate

    z *= rot(iTime/13.);
    
    float inf = 1e6;
    for ( O *= 0. ; i++ < 12. && dot(z,z) < inf; ) {
   
        float x2 = z.x*z.x;
        float y2 = z.y*z.y;
                        
        float z3_re = x2*z.x - 3.0*z.x*y2;
        float z3_im = -y2*z.y + 3.0*x2*z.y;
        float z3_modsq = max(z3_re*z3_re + z3_im*z3_im, too_small);

        vec2 v = vec2( z3_re, z3_im );
        
        z = (1.-mixf[ii])*abs(v)
            +mixf[ii]*abs(v)/z3_modsq  
            + M;
                
    }
    
    if (dot(z,z) < inf) {
        //only interested in points that stay bounded
        vec2 cc = sin( log( abs(z) ) * vec2(2.,.2) ) ;
        cc *= cc;
        
        float aa = atan(z.y,z.x);
        aa = sin(aa*2.);
        aa *= aa;
    
        vec3 ccc =  vec3(1.5,.6,0)*cc.x 
                    + vec3(.2,.6,1.5)*cc.y
                    + 2.*vec3(1,.6,0)*aa
                    ;
                    
        O = vec4(ccc,0);
        O = 1. - exp(-O*O);
    }


}
#define O fragColor
#define U fragCoord
//FabriceNeyret2 antialiasing trick
//void mainImage(out vec4 O, vec2 U) {
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{ 
    mainImage0(O,U);
    if ( fwidth(length(O)) > .01 ) {  // difference threshold between neighbor pixels
        vec4 o;
        for (int k=0; k < 9; k+= k==3?2:1 )
          { mainImage0(o,U+vec2(k%3-1,k/3-1)/3.); O += o; }
        O /= 9.;
        //O.b++;                        // uncomment to see where the oversampling occurs
    }
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below 
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
gl_FragColor.a = length(gl_FragColor.rgb);
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

